//
//  OPXAuth.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2016-08-16.
//
//

#import <Foundation/Foundation.h>

@protocol OPXPayloadKey;

// response keys
FOUNDATION_EXPORT NSString * const OPXAuthResponseActionKey;// = @"action";
FOUNDATION_EXPORT NSString * const OPXAuthResponsePayloadKey;// = @"payload";

// actions
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthRegister; // = @"authRegister";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthRegistered; // = @"authRegistered";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthNew; // = @"authNew";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthBegin; // = @"authBegin";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthContinue;// = @"authContinue";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthVerify;// = @"authVerify";
FOUNDATION_EXPORT NSString * const OPXAuthActionAuthFail;// = @"authFail";

// auth keys
FOUNDATION_EXPORT NSString * const OPXAuthExtIdKey;// = @"extId";
FOUNDATION_EXPORT NSString * const OPXAuthMethodKey;// = @"method";
FOUNDATION_EXPORT NSString * const OPXAuthAlgKey;// = @"alg";

// authNew keys
FOUNDATION_EXPORT NSString * const OPXAuthNewCodeKey;// = @"code";

// authRegister keys
FOUNDATION_EXPORT NSString * const OPXAuthRegisterSecretKey;// = @"secret";

// authBegin keys
FOUNDATION_EXPORT NSString * const OPXAuthBeginCCKey;// = @"cc";
FOUNDATION_EXPORT NSString * const OPXAuthBeginCSKey;// = @"cs";
FOUNDATION_EXPORT NSString * const OPXAuthBeginM3Key;// = @"M3";

// authContinue keys

// authVerify keys
FOUNDATION_EXPORT NSString * const OPXAuthVerifyM4Key;// = @"M4";

// authFail keys
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonKey;// = @"reason";

// authFail Reasons
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonUserRefused;// = @"user-refused";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonBadMac;// = @"bad-mac";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonBadParameter;// = @"bad-parameter";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonNoMethod;// = @"no-method";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonNoAlg;// = @"no-alg";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonInternal;// = @"internal";
FOUNDATION_EXPORT NSString * const OPXAuthFailReasonUnknown;// = @"unknown";

// auth info dictionary keys
FOUNDATION_EXPORT NSString * const OPXAuthInfoDictionaryMethodKey;// = @"method";

@protocol OPXAuth <NSObject>

+ (NSArray <NSString*> *)supportedMethods;
+ (NSArray <NSString*> *)supportedEncryptionAlgorithms;
+ (NSString *)preferredMethodFromList:(NSArray *)extensionMethods;
+ (NSString *)preferredEncryptionAlgorithmFromList:(NSArray *)extensionAlgorithms;

+ (instancetype)authWithExtId:(NSString *)extId method:(NSString *)method alg:(NSString *)alg;
+ (instancetype)authWithExtId:(NSString *)extId authInfoDictionary:(NSDictionary *)authInfoDictionary alg:(NSString *)alg;

@property (nonatomic, readonly, copy) NSString *code;
@property (nonatomic, readonly, copy) NSString *extId;
@property (nonatomic, readonly, copy) NSString *method;
@property (nonatomic, readonly, copy) NSString *alg;

// Returns a dictionary that the app can persist to disk which will allow it to recreate an OPXAuth object from later.
- (NSDictionary *)authInfoDictionary;

// Returns a dictionary that includes keys: action (string), payload (dictionary) for message to OPX when initialized from +authWithExtId:method:
- (NSDictionary *)authNewMessage;

// Returns a dictionary that includes keys: action (string), payload (dictionary) for message to OPX when initialized from +authWithExtId:authInfoDictionary:
- (NSDictionary *)authBeginMessage;

// Returns a dictionary that includes keys: action (string), payload (dictionary) for response to OPX
- (NSDictionary *)registerWithPayload:(NSDictionary *)authRegisterPayload;

// Returns a dictionary that includes keys: action (string), payload (dictionary) for response to OPX
- (NSDictionary *)beginWithPayload:(NSDictionary *)authBeginPayload;

// Returns a dictionary that includes keys: action (string), payload (dictionary) for response to OPX
- (NSDictionary *)verifyWithPayload:(NSDictionary *)authVerifyPayload;

- (id<OPXPayloadKey>)payloadKey;

@end

NSString *OPXAuthPreferredAuthMethodFromCapabilities(NSArray *capabilities);
Class<OPXAuth> OPXAuthClassForMethod(NSString *method);
NSDictionary *OPXAuthErrorResponseWithReason(NSString *reason);
NSString *OPXAuthGenerateNewCode();
